package com.xforceplus.ultraman.app.jccrland.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jccrland.entity.Organization;
import com.xforceplus.ultraman.app.jccrland.service.IOrganizationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-01
 */
@RestController
public class OrganizationController {

  @Autowired
  private IOrganizationService organizationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param organization ${table.comment}
   * @return
   */
  @GetMapping("/organizations" )
  public XfR getOrganizations(XfPage page, Organization organization) {
    return XfR.ok(organizationServiceImpl.page(page, Wrappers.query(organization)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/organizations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(organizationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param organization ${table.comment}
   * @return XfR
   */
  @PostMapping("/organizations")
  public XfR save(@RequestBody Organization organization) {
     return XfR.ok(organizationServiceImpl.save(organization));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param organization ${table.comment}
   * @return XfR
   */
  @PutMapping("/organizations/{id}")
  public XfR putUpdate(@RequestBody Organization organization,@PathVariable Long id) {
      organization.setId(id);
      return XfR.ok(organizationServiceImpl.updateById(organization));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param organization ${table.comment}
   * @return XfR
   */
  @PatchMapping("/organizations/{id}")
  public XfR patchUpdate(@RequestBody Organization organization,@PathVariable Long id) {
      Organization uporganization = organizationServiceImpl.getById(id);
      if(uporganization != null){
        uporganization = ObjectCopyUtils.copyProperties(organization,uporganization,true);
      }
      return XfR.ok(organizationServiceImpl.updateById(uporganization));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/organizations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(organizationServiceImpl.removeById(id));
  }

  @PostMapping("/organizations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "organization");
     params.put("request", condition);

     return XfR.ok(organizationServiceImpl.querys(params));
  }

}
