package com.xforceplus.ultraman.app.jccrland.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jccrland.entity.OrganizationYx;
import com.xforceplus.ultraman.app.jccrland.service.IOrganizationYxService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 前端控制器
 *
 * @author ultraman
 * @date 2024-11-01
 */
@RestController
public class OrganizationYxController {

  @Autowired
  private IOrganizationYxService organizationYxServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param organizationYx 
   * @return
   */
  @GetMapping("/organizationyxs" )
  public XfR getOrganizationYxs(XfPage page, OrganizationYx organizationYx) {
    return XfR.ok(organizationYxServiceImpl.page(page, Wrappers.query(organizationYx)));
  }

  /**
   * 通过id查询
   * @param  id
   * @return XfR
   */
  @GetMapping("/organizationyxs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(organizationYxServiceImpl.getById(id));
  }

  /**
   * 新增
   * @param organizationYx 
   * @return XfR
   */
  @PostMapping("/organizationyxs")
  public XfR save(@RequestBody OrganizationYx organizationYx) {
     return XfR.ok(organizationYxServiceImpl.save(organizationYx));
  }

  /**
   * 修改-传入修改后的全部数据
   * @param organizationYx 
   * @return XfR
   */
  @PutMapping("/organizationyxs/{id}")
  public XfR putUpdate(@RequestBody OrganizationYx organizationYx,@PathVariable Long id) {
      organizationYx.setId(id);
      return XfR.ok(organizationYxServiceImpl.updateById(organizationYx));
  }

  /**
   * 修改-传入修改的数据
   * @param organizationYx 
   * @return XfR
   */
  @PatchMapping("/organizationyxs/{id}")
  public XfR patchUpdate(@RequestBody OrganizationYx organizationYx,@PathVariable Long id) {
      OrganizationYx uporganizationYx = organizationYxServiceImpl.getById(id);
      if(uporganizationYx != null){
        uporganizationYx = ObjectCopyUtils.copyProperties(organizationYx,uporganizationYx,true);
      }
      return XfR.ok(organizationYxServiceImpl.updateById(uporganizationYx));
  }

  /**
   * 通过id删除
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/organizationyxs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(organizationYxServiceImpl.removeById(id));
  }

  @PostMapping("/organizationyxs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "organization_yx");
     params.put("request", condition);

     return XfR.ok(organizationYxServiceImpl.querys(params));
  }

}
