package com.xforceplus.ultraman.app.jccrland.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jccrland.entity.Product;
import com.xforceplus.ultraman.app.jccrland.service.IProductService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-01
 */
@RestController
public class ProductController {

  @Autowired
  private IProductService productServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param product ${table.comment}
   * @return
   */
  @GetMapping("/products" )
  public XfR getProducts(XfPage page, Product product) {
    return XfR.ok(productServiceImpl.page(page, Wrappers.query(product)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/products/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(productServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param product ${table.comment}
   * @return XfR
   */
  @PostMapping("/products")
  public XfR save(@RequestBody Product product) {
     return XfR.ok(productServiceImpl.save(product));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param product ${table.comment}
   * @return XfR
   */
  @PutMapping("/products/{id}")
  public XfR putUpdate(@RequestBody Product product,@PathVariable Long id) {
      product.setId(id);
      return XfR.ok(productServiceImpl.updateById(product));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param product ${table.comment}
   * @return XfR
   */
  @PatchMapping("/products/{id}")
  public XfR patchUpdate(@RequestBody Product product,@PathVariable Long id) {
      Product upproduct = productServiceImpl.getById(id);
      if(upproduct != null){
        upproduct = ObjectCopyUtils.copyProperties(product,upproduct,true);
      }
      return XfR.ok(productServiceImpl.updateById(upproduct));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/products/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(productServiceImpl.removeById(id));
  }

  @PostMapping("/products/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "product");
     params.put("request", condition);

     return XfR.ok(productServiceImpl.querys(params));
  }

}
