package com.xforceplus.ultraman.app.jccrland.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jccrland.entity.ProjectSelect;
import com.xforceplus.ultraman.app.jccrland.service.IProjectSelectService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-01
 */
@RestController
public class ProjectSelectController {

  @Autowired
  private IProjectSelectService projectSelectServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param projectSelect ${table.comment}
   * @return
   */
  @GetMapping("/projectselects" )
  public XfR getProjectSelects(XfPage page, ProjectSelect projectSelect) {
    return XfR.ok(projectSelectServiceImpl.page(page, Wrappers.query(projectSelect)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/projectselects/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(projectSelectServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param projectSelect ${table.comment}
   * @return XfR
   */
  @PostMapping("/projectselects")
  public XfR save(@RequestBody ProjectSelect projectSelect) {
     return XfR.ok(projectSelectServiceImpl.save(projectSelect));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param projectSelect ${table.comment}
   * @return XfR
   */
  @PutMapping("/projectselects/{id}")
  public XfR putUpdate(@RequestBody ProjectSelect projectSelect,@PathVariable Long id) {
      projectSelect.setId(id);
      return XfR.ok(projectSelectServiceImpl.updateById(projectSelect));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param projectSelect ${table.comment}
   * @return XfR
   */
  @PatchMapping("/projectselects/{id}")
  public XfR patchUpdate(@RequestBody ProjectSelect projectSelect,@PathVariable Long id) {
      ProjectSelect upprojectSelect = projectSelectServiceImpl.getById(id);
      if(upprojectSelect != null){
        upprojectSelect = ObjectCopyUtils.copyProperties(projectSelect,upprojectSelect,true);
      }
      return XfR.ok(projectSelectServiceImpl.updateById(upprojectSelect));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/projectselects/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(projectSelectServiceImpl.removeById(id));
  }

  @PostMapping("/projectselects/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "project_select");
     params.put("request", condition);

     return XfR.ok(projectSelectServiceImpl.querys(params));
  }

}
