/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.app.jccrland.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.app.jccrland.entity.Product;
import com.xforceplus.ultraman.app.jccrland.service.IProductService;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProductController {
    @Autowired
    private IProductService productServiceImpl;

    @GetMapping(value={"/products"})
    public XfR getProducts(XfPage page, Product product) {
        return XfR.ok((Object)this.productServiceImpl.page((IPage)page, (Wrapper)Wrappers.query((Object)product)));
    }

    @GetMapping(value={"/products/{id}"})
    public XfR getById(@PathVariable Long id) {
        return XfR.ok((Object)this.productServiceImpl.getById(id));
    }

    @PostMapping(value={"/products"})
    public XfR save(@RequestBody Product product) {
        return XfR.ok((Object)this.productServiceImpl.save(product));
    }

    @PutMapping(value={"/products/{id}"})
    public XfR putUpdate(@RequestBody Product product, @PathVariable Long id) {
        product.setId(id);
        return XfR.ok((Object)this.productServiceImpl.updateById(product));
    }

    @PatchMapping(value={"/products/{id}"})
    public XfR patchUpdate(@RequestBody Product product, @PathVariable Long id) {
        Product upproduct = (Product)this.productServiceImpl.getById(id);
        if (upproduct != null) {
            upproduct = (Product)ObjectCopyUtils.copyProperties((Object)product, (Object)upproduct, (boolean)true);
        }
        return XfR.ok((Object)this.productServiceImpl.updateById(upproduct));
    }

    @DeleteMapping(value={"/products/{id}"})
    public XfR removeById(@PathVariable Long id) {
        return XfR.ok((Object)this.productServiceImpl.removeById(id));
    }

    @PostMapping(value={"/products/query"})
    public XfR querys(@RequestBody ConditionQueryRequest condition) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableName", "product");
        params.put("request", condition);
        return XfR.ok(this.productServiceImpl.querys(params));
    }
}

