package com.xforceplus.ultraman.app.jccrland.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jccrland.entity.BillInvoiceList;
import com.xforceplus.ultraman.app.jccrland.service.IBillInvoiceListService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-10-11
 */
@RestController
public class BillInvoiceListController {

  @Autowired
  private IBillInvoiceListService billInvoiceListServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billInvoiceList ${table.comment}
   * @return
   */
  @GetMapping("/billinvoicelists" )
  public XfR getBillInvoiceLists(XfPage page, BillInvoiceList billInvoiceList) {
    return XfR.ok(billInvoiceListServiceImpl.page(page, Wrappers.query(billInvoiceList)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billinvoicelists/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billInvoiceListServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billInvoiceList ${table.comment}
   * @return XfR
   */
  @PostMapping("/billinvoicelists")
  public XfR save(@RequestBody BillInvoiceList billInvoiceList) {
     return XfR.ok(billInvoiceListServiceImpl.save(billInvoiceList));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billInvoiceList ${table.comment}
   * @return XfR
   */
  @PutMapping("/billinvoicelists/{id}")
  public XfR putUpdate(@RequestBody BillInvoiceList billInvoiceList,@PathVariable Long id) {
      billInvoiceList.setId(id);
      return XfR.ok(billInvoiceListServiceImpl.updateById(billInvoiceList));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billInvoiceList ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billinvoicelists/{id}")
  public XfR patchUpdate(@RequestBody BillInvoiceList billInvoiceList,@PathVariable Long id) {
      BillInvoiceList upbillInvoiceList = billInvoiceListServiceImpl.getById(id);
      if(upbillInvoiceList != null){
        upbillInvoiceList = ObjectCopyUtils.copyProperties(billInvoiceList,upbillInvoiceList,true);
      }
      return XfR.ok(billInvoiceListServiceImpl.updateById(upbillInvoiceList));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billinvoicelists/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billInvoiceListServiceImpl.removeById(id));
  }

  @PostMapping("/billinvoicelists/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_invoice_list");
     params.put("request", condition);

     return XfR.ok(billInvoiceListServiceImpl.querys(params));
  }

}
