package com.xforceplus.ultraman.app.jccrland.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jccrland.entity.CityCompany;
import com.xforceplus.ultraman.app.jccrland.service.ICityCompanyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-10-11
 */
@RestController
public class CityCompanyController {

  @Autowired
  private ICityCompanyService cityCompanyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param cityCompany ${table.comment}
   * @return
   */
  @GetMapping("/citycompanys" )
  public XfR getCityCompanys(XfPage page, CityCompany cityCompany) {
    return XfR.ok(cityCompanyServiceImpl.page(page, Wrappers.query(cityCompany)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/citycompanys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(cityCompanyServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param cityCompany ${table.comment}
   * @return XfR
   */
  @PostMapping("/citycompanys")
  public XfR save(@RequestBody CityCompany cityCompany) {
     return XfR.ok(cityCompanyServiceImpl.save(cityCompany));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param cityCompany ${table.comment}
   * @return XfR
   */
  @PutMapping("/citycompanys/{id}")
  public XfR putUpdate(@RequestBody CityCompany cityCompany,@PathVariable Long id) {
      cityCompany.setId(id);
      return XfR.ok(cityCompanyServiceImpl.updateById(cityCompany));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param cityCompany ${table.comment}
   * @return XfR
   */
  @PatchMapping("/citycompanys/{id}")
  public XfR patchUpdate(@RequestBody CityCompany cityCompany,@PathVariable Long id) {
      CityCompany upcityCompany = cityCompanyServiceImpl.getById(id);
      if(upcityCompany != null){
        upcityCompany = ObjectCopyUtils.copyProperties(cityCompany,upcityCompany,true);
      }
      return XfR.ok(cityCompanyServiceImpl.updateById(upcityCompany));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/citycompanys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(cityCompanyServiceImpl.removeById(id));
  }

  @PostMapping("/citycompanys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "city_company");
     params.put("request", condition);

     return XfR.ok(cityCompanyServiceImpl.querys(params));
  }

}
