package com.xforceplus.ultraman.app.jccrland.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jccrland.entity.SystemWorkflowInstanceHistory;
import com.xforceplus.ultraman.app.jccrland.service.ISystemWorkflowInstanceHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统工作流流程实例历史对象前端控制器
 *
 * @author ultraman
 * @date 2024-10-11
 */
@RestController
public class SystemWorkflowInstanceHistoryController {

  @Autowired
  private ISystemWorkflowInstanceHistoryService systemWorkflowInstanceHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemWorkflowInstanceHistory 系统工作流流程实例历史对象
   * @return
   */
  @GetMapping("/systemworkflowinstancehistorys" )
  public XfR getSystemWorkflowInstanceHistorys(XfPage page, SystemWorkflowInstanceHistory systemWorkflowInstanceHistory) {
    return XfR.ok(systemWorkflowInstanceHistoryServiceImpl.page(page, Wrappers.query(systemWorkflowInstanceHistory)));
  }

  /**
   * 通过id查询系统工作流流程实例历史对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemworkflowinstancehistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemWorkflowInstanceHistoryServiceImpl.getById(id));
  }

  /**
   * 新增系统工作流流程实例历史对象
   * @param systemWorkflowInstanceHistory 系统工作流流程实例历史对象
   * @return XfR
   */
  @PostMapping("/systemworkflowinstancehistorys")
  public XfR save(@RequestBody SystemWorkflowInstanceHistory systemWorkflowInstanceHistory) {
     return XfR.ok(systemWorkflowInstanceHistoryServiceImpl.save(systemWorkflowInstanceHistory));
  }

  /**
   * 修改-传入修改后的全部数据系统工作流流程实例历史对象
   * @param systemWorkflowInstanceHistory 系统工作流流程实例历史对象
   * @return XfR
   */
  @PutMapping("/systemworkflowinstancehistorys/{id}")
  public XfR putUpdate(@RequestBody SystemWorkflowInstanceHistory systemWorkflowInstanceHistory,@PathVariable Long id) {
      systemWorkflowInstanceHistory.setId(id);
      return XfR.ok(systemWorkflowInstanceHistoryServiceImpl.updateById(systemWorkflowInstanceHistory));
  }

  /**
   * 修改-传入修改的数据系统工作流流程实例历史对象
   * @param systemWorkflowInstanceHistory 系统工作流流程实例历史对象
   * @return XfR
   */
  @PatchMapping("/systemworkflowinstancehistorys/{id}")
  public XfR patchUpdate(@RequestBody SystemWorkflowInstanceHistory systemWorkflowInstanceHistory,@PathVariable Long id) {
      SystemWorkflowInstanceHistory upsystemWorkflowInstanceHistory = systemWorkflowInstanceHistoryServiceImpl.getById(id);
      if(upsystemWorkflowInstanceHistory != null){
        upsystemWorkflowInstanceHistory = ObjectCopyUtils.copyProperties(systemWorkflowInstanceHistory,upsystemWorkflowInstanceHistory,true);
      }
      return XfR.ok(systemWorkflowInstanceHistoryServiceImpl.updateById(upsystemWorkflowInstanceHistory));
  }

  /**
   * 通过id删除系统工作流流程实例历史对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemworkflowinstancehistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemWorkflowInstanceHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/systemworkflowinstancehistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_workflow_instance_history");
     params.put("request", condition);

     return XfR.ok(systemWorkflowInstanceHistoryServiceImpl.querys(params));
  }

}
