package com.xforceplus.ultraman.app.jccrland.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jccrland.entity.YxMakeInvoiceSetting;
import com.xforceplus.ultraman.app.jccrland.service.IYxMakeInvoiceSettingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-10-11
 */
@RestController
public class YxMakeInvoiceSettingController {

  @Autowired
  private IYxMakeInvoiceSettingService yxMakeInvoiceSettingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param yxMakeInvoiceSetting ${table.comment}
   * @return
   */
  @GetMapping("/yxmakeinvoicesettings" )
  public XfR getYxMakeInvoiceSettings(XfPage page, YxMakeInvoiceSetting yxMakeInvoiceSetting) {
    return XfR.ok(yxMakeInvoiceSettingServiceImpl.page(page, Wrappers.query(yxMakeInvoiceSetting)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/yxmakeinvoicesettings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(yxMakeInvoiceSettingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param yxMakeInvoiceSetting ${table.comment}
   * @return XfR
   */
  @PostMapping("/yxmakeinvoicesettings")
  public XfR save(@RequestBody YxMakeInvoiceSetting yxMakeInvoiceSetting) {
     return XfR.ok(yxMakeInvoiceSettingServiceImpl.save(yxMakeInvoiceSetting));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param yxMakeInvoiceSetting ${table.comment}
   * @return XfR
   */
  @PutMapping("/yxmakeinvoicesettings/{id}")
  public XfR putUpdate(@RequestBody YxMakeInvoiceSetting yxMakeInvoiceSetting,@PathVariable Long id) {
      yxMakeInvoiceSetting.setId(id);
      return XfR.ok(yxMakeInvoiceSettingServiceImpl.updateById(yxMakeInvoiceSetting));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param yxMakeInvoiceSetting ${table.comment}
   * @return XfR
   */
  @PatchMapping("/yxmakeinvoicesettings/{id}")
  public XfR patchUpdate(@RequestBody YxMakeInvoiceSetting yxMakeInvoiceSetting,@PathVariable Long id) {
      YxMakeInvoiceSetting upyxMakeInvoiceSetting = yxMakeInvoiceSettingServiceImpl.getById(id);
      if(upyxMakeInvoiceSetting != null){
        upyxMakeInvoiceSetting = ObjectCopyUtils.copyProperties(yxMakeInvoiceSetting,upyxMakeInvoiceSetting,true);
      }
      return XfR.ok(yxMakeInvoiceSettingServiceImpl.updateById(upyxMakeInvoiceSetting));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/yxmakeinvoicesettings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(yxMakeInvoiceSettingServiceImpl.removeById(id));
  }

  @PostMapping("/yxmakeinvoicesettings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "yx_make_invoice_setting");
     params.put("request", condition);

     return XfR.ok(yxMakeInvoiceSettingServiceImpl.querys(params));
  }

}
