package com.xforceplus.ultraman.app.jcdisney.controller;


/**
 * 报表统计feign客户端
 *
 * @author ultraman
 * @date 2022-08-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcdisney.entity.ReportStatistics;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-disney")
public interface ReportStatisticsFeignApi {

  /**
   * 通过id查询报表统计
   * @param  id
   * @return R
   */
  @GetMapping("/reportStatistics/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增报表统计
   * @param reportStatistics 报表统计
   * @return R
   */
  @PostMapping("/reportStatistics/add")
  public R save(@RequestBody ReportStatistics reportStatistics);

  /**
   * 修改报表统计
   * @param reportStatistics 报表统计
   * @return R
   */
  @PostMapping("/reportStatistics/update")
  public R updateById(@RequestBody ReportStatistics reportStatistics);

  /**
   * 通过id删除报表统计
   * @param  id
   * @return R
   */
  @DeleteMapping("/reportStatistics/del/{id}" )
  public R removeById(@PathVariable Long id);

}