package com.xforceplus.ultraman.app.jcdomino.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_kind
 * </p>
 *
 * @author ultraman
 * @since 2024-10-18
 */
public enum InvoiceKind {

    C("c", "纸质发票（增值税普通发票）"),
    S("s", "纸质发票（增值税专用发票）"),
    CE("ce", "电子发票（增值税普通发票）"),
    SE("se", "电子发票（增值税专用发票）"),
    V("v", "机动车销售统一发票"),
    VS("vs", "二手车销售统一发票"),
    JU("ju", "增值税普通发票（卷票）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceKind(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceKind fromCode(String code){
        switch(code) {
            case "c":
                return C;
            case "s":
                return S;
            case "ce":
                return CE;
            case "se":
                return SE;
            case "v":
                return V;
            case "vs":
                return VS;
            case "ju":
                return JU;
            default:
                return null;
        }
    }
}
