package com.xforceplus.ultraman.app.jcdomino.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_status
 * </p>
 *
 * @author ultraman
 * @since 2024-10-18
 */
public enum InvoiceStatus {

    _0("0", "未开具"),
    _1("1", "已开具"),
    _2("2", "部分开具"),
    _3("3", "已回填"),
    _4("4", "部分回填"),
    _5("5", "回填异常"),
    _6("6", "回填中");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
