package com.xforceplus.ultraman.app.jcdomino.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 数据类型
 * </p>
 *
 * @author ultraman
 * @since 2023-10-31
 */
public enum DataType {

    _1("1", "单据"),
    _2("2", "单据明细"),
    _3("3", "发票数据和明细"),
    _4("4", "附件");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DataType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataType fromCode(String code) {
        return Stream.of(DataType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
