package com.xforceplus.ultraman.app.jcdomino.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票票种
 * </p>
 *
 * @author ultraman
 * @since 2023-10-31
 */
public enum InvoiceKind {

    C("c", "纸质发票（增值税普通发票）"),
    S("s", "纸质发票（增值税专用发票）"),
    CE("ce", "电子发票（增值税普通发票）"),
    SE("se", "电子发票（增值税专用发票）"),
    V("v", "机动车销售统一发票"),
    VS("vs", "二手车销售统一发票"),
    JU("ju", "增值税普通发票（卷票）");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceKind(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceKind fromCode(String code) {
        return Stream.of(InvoiceKind.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
