package com.xforceplus.ultraman.app.jcdomino.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票来源
 * </p>
 *
 * @author ultraman
 * @since 2023-10-31
 */
public enum InvoiceOrigin {

    _1("1", "协同平台回填"),
    _2("2", "属地配单推送协同");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceOrigin(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceOrigin fromCode(String code) {
        return Stream.of(InvoiceOrigin.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
