package com.xforceplus.ultraman.app.jcdomino.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票状态
 * </p>
 *
 * @author ultraman
 * @since 2023-10-31
 */
public enum InvoiceStatus {

    _0("0", "未开具"),
    _1("1", "已开具"),
    _2("2", "部分开具"),
    _3("3", "已回填"),
    _4("4", "部分回填"),
    _5("5", "回填异常"),
    _6("6", "回填中");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceStatus fromCode(String code) {
        return Stream.of(InvoiceStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
