package com.xforceplus.ultraman.app.jcdomino.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务单下发状态
 * </p>
 *
 * @author ultraman
 * @since 2023-10-31
 */
public enum BillSendStatus {

    _0("0", "未下发"),
    _1("1", "已下发");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillSendStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillSendStatus fromCode(String code) {
        return Stream.of(BillSendStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
