package com.xforceplus.ultraman.app.jcdomino.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务单据类型
 * </p>
 *
 * @author ultraman
 * @since 2023-10-31
 */
public enum BusinessBillType {

    AP("AP", "购方"),
    AR("AR", "销方");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BusinessBillType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessBillType fromCode(String code) {
        return Stream.of(BusinessBillType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
