package com.xforceplus.ultraman.app.jcdomino.metadata.validator;

import com.xforceplus.ultraman.app.jcdomino.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.jcdomino.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-10-31
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessBillType.class)) {
            isValid = null != BusinessBillType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessBillType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceKind.class)) {
            isValid = null != InvoiceKind.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceKind.class.getSimpleName());
            }
        }
        if(clazz.equals(PriceMethod.class)) {
            isValid = null != PriceMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PriceMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceOrigin.class)) {
            isValid = null != InvoiceOrigin.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceOrigin.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = null != InvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(LockStatus.class)) {
            isValid = null != LockStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, LockStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillSendStatus.class)) {
            isValid = null != BillSendStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillSendStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DataType.class)) {
            isValid = null != DataType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataType.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
