package com.xforceplus.ultraman.app.jcdomino.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcdomino.entity.OriginData;
import com.xforceplus.ultraman.app.jcdomino.service.IOriginDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-11-28
 */
@RestController
public class OriginDataController {

  @Autowired
  private IOriginDataService originDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param originData ${table.comment}
   * @return
   */
  @GetMapping("/origindatas" )
  public XfR getOriginDatas(XfPage page, OriginData originData) {
    return XfR.ok(originDataServiceImpl.page(page, Wrappers.query(originData)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/origindatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(originDataServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param originData ${table.comment}
   * @return XfR
   */
  @PostMapping("/origindatas")
  public XfR save(@RequestBody OriginData originData) {
     return XfR.ok(originDataServiceImpl.save(originData));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param originData ${table.comment}
   * @return XfR
   */
  @PutMapping("/origindatas/{id}")
  public XfR putUpdate(@RequestBody OriginData originData,@PathVariable Long id) {
      originData.setId(id);
      return XfR.ok(originDataServiceImpl.updateById(originData));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param originData ${table.comment}
   * @return XfR
   */
  @PatchMapping("/origindatas/{id}")
  public XfR patchUpdate(@RequestBody OriginData originData,@PathVariable Long id) {
      OriginData uporiginData = originDataServiceImpl.getById(id);
      if(uporiginData != null){
        uporiginData = ObjectCopyUtils.copyProperties(originData,uporiginData,true);
      }
      return XfR.ok(originDataServiceImpl.updateById(uporiginData));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/origindatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(originDataServiceImpl.removeById(id));
  }

  @PostMapping("/origindatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "origin_data");
     params.put("request", condition);

     return XfR.ok(originDataServiceImpl.querys(params));
  }

}
