package com.xforceplus.ultraman.app.jchanhui.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jchanhui.entity.ScanBuss;
import com.xforceplus.ultraman.app.jchanhui.service.IScanBussService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-03-22
 */
@RestController
public class ScanBussController {

  @Autowired
  private IScanBussService scanBussServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param scanBuss ${table.comment}
   * @return
   */
  @GetMapping("/scanbusss" )
  public XfR getScanBusss(XfPage page, ScanBuss scanBuss) {
    return XfR.ok(scanBussServiceImpl.page(page, Wrappers.query(scanBuss)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/scanbusss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(scanBussServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param scanBuss ${table.comment}
   * @return XfR
   */
  @PostMapping("/scanbusss")
  public XfR save(@RequestBody ScanBuss scanBuss) {
     return XfR.ok(scanBussServiceImpl.save(scanBuss));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param scanBuss ${table.comment}
   * @return XfR
   */
  @PutMapping("/scanbusss/{id}")
  public XfR putUpdate(@RequestBody ScanBuss scanBuss,@PathVariable Long id) {
      scanBuss.setId(id);
      return XfR.ok(scanBussServiceImpl.updateById(scanBuss));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param scanBuss ${table.comment}
   * @return XfR
   */
  @PatchMapping("/scanbusss/{id}")
  public XfR patchUpdate(@RequestBody ScanBuss scanBuss,@PathVariable Long id) {
      ScanBuss upscanBuss = scanBussServiceImpl.getById(id);
      if(upscanBuss != null){
        upscanBuss = ObjectCopyUtils.copyProperties(scanBuss,upscanBuss,true);
      }
      return XfR.ok(scanBussServiceImpl.updateById(upscanBuss));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/scanbusss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(scanBussServiceImpl.removeById(id));
  }

  @PostMapping("/scanbusss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "scan_buss");
     params.put("request", condition);

     return XfR.ok(scanBussServiceImpl.querys(params));
  }

}
