package com.xforceplus.ultraman.app.jchgmart.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 订单类型
 * </p>
 *
 * @author ultraman
 * @since 2022-09-05
 */
public enum OrderType {

    BH("bh", "百货"),
    CS("cs", "超市");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OrderType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrderType fromCode(String code){
        switch(code) {
            case "bh":
                return BH;
            case "cs":
                return CS;
            default:
                return null;
        }
    }
}
