package com.xforceplus.ultraman.app.jchsufuchifoods.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 红字信息表主信息
 * </p>
 *
 * @author ultraman
 * @since 2022-06-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class RedLetterInvoiceMain implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 设备唯一编码
   */
  @TableField("deviceUn")
  private String deviceUn;

  /**
   * 终端唯一编码
   */
  @TableField("terminalUn")
  private String terminalUn;

  /**
   * 申请流水号
   */
  @TableField("applySerialNo")
  private String applySerialNo;

  /**
   * 成品油操作类型
   */
  @TableField("oilMemo")
  private String oilMemo;

  /**
   * 购方税号
   */
  @TableField("buyerTaxNo")
  private String buyerTaxNo;

  /**
   * 购方名称
   */
  @TableField("buyerName")
  private String buyerName;

  /**
   * 销方税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 对应蓝票发票代码
   */
  @TableField("originInvoiceCode")
  private String originInvoiceCode;

  /**
   * 对应蓝票发票号码
   */
  @TableField("originInvoiceNo")
  private String originInvoiceNo;

  /**
   * 对应蓝票发票类型
   */
  @TableField("originInvoiceType")
  private String originInvoiceType;

  /**
   * 对应蓝票开票日期
   */
  @TableField("originDateIssued")
  private String originDateIssued;

  /**
   * 申请说明
   */
  @TableField("applicationReason")
  private String applicationReason;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 原发票主表ID
   */
  @TableField("originInvoiceId")
  private Long originInvoiceId;

  /**
   * 红字信息表状态
   */
  private String status;

  /**
   * 申请任务ID
   */
  @TableField("applyTaskId")
  private String applyTaskId;

  /**
   * 申请返回结果
   */
  @TableField("applyResult")
  private String applyResult;

  /**
   * 撤销任务ID
   */
  @TableField("cancelTaskId")
  private String cancelTaskId;

  /**
   * 撤销返回结果
   */
  @TableField("cancelResult")
  private String cancelResult;

  /**
   * 红字信息编号
   */
  @TableField("redLetterNumber")
  private String redLetterNumber;

  /**
   * 申请状态
   */
  @TableField("applyStatus")
  private String applyStatus;

  /**
   * 填开时间
   */
  @TableField("applyTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyTime;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("deviceUn", deviceUn);
      map.put("terminalUn", terminalUn);
      map.put("applySerialNo", applySerialNo);
      map.put("oilMemo", oilMemo);
      map.put("buyerTaxNo", buyerTaxNo);
      map.put("buyerName", buyerName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerName", sellerName);
      map.put("originInvoiceCode", originInvoiceCode);
      map.put("originInvoiceNo", originInvoiceNo);
      map.put("originInvoiceType", originInvoiceType);
      map.put("originDateIssued", originDateIssued);
      map.put("applicationReason", applicationReason);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("amountWithTax", amountWithTax);
      map.put("taxAmount", taxAmount);
      map.put("originInvoiceId", originInvoiceId);
      map.put("status", status);
      map.put("applyTaskId", applyTaskId);
      map.put("applyResult", applyResult);
      map.put("cancelTaskId", cancelTaskId);
      map.put("cancelResult", cancelResult);
      map.put("redLetterNumber", redLetterNumber);
      map.put("applyStatus", applyStatus);
      map.put("applyTime", BocpGenUtils.toTimestamp(applyTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static RedLetterInvoiceMain fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    RedLetterInvoiceMain entity = new RedLetterInvoiceMain();
    if(map.containsKey("deviceUn")) {
      Object obj = map.get("deviceUn");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeviceUn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("terminalUn")) {
      Object obj = map.get("terminalUn");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTerminalUn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applySerialNo")) {
      Object obj = map.get("applySerialNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplySerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oilMemo")) {
      Object obj = map.get("oilMemo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOilMemo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceType")) {
      Object obj = map.get("originInvoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originDateIssued")) {
      Object obj = map.get("originDateIssued");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginDateIssued((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applicationReason")) {
      Object obj = map.get("applicationReason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicationReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceId")) {
      Object obj = map.get("originInvoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOriginInvoiceId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOriginInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOriginInvoiceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyTaskId")) {
      Object obj = map.get("applyTaskId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyResult")) {
      Object obj = map.get("applyResult");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyResult((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cancelTaskId")) {
      Object obj = map.get("cancelTaskId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCancelTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cancelResult")) {
      Object obj = map.get("cancelResult");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCancelResult((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redLetterNumber")) {
      Object obj = map.get("redLetterNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedLetterNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyStatus")) {
      Object obj = map.get("applyStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyTime")) {
      Object obj = map.get("applyTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
