package com.xforceplus.ultraman.app.jchsufuchifoods.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 规则配置类型
 * </p>
 *
 * @author ultraman
 * @since 2021-11-29
 */
public enum RuleConfigType {

    PRICE_QUANTITY_RULE("priceQuantityRule", "价格数量规则配置"),
    LIGHT_SEASON("lightSeason", "淡旺季限额配置"),
    DISCOUNT_RATE("discountRate", "折扣率预警报错配置");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RuleConfigType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RuleConfigType fromCode(String code){
        switch(code) {
            case "priceQuantityRule":
                return PRICE_QUANTITY_RULE;
            case "lightSeason":
                return LIGHT_SEASON;
            case "discountRate":
                return DISCOUNT_RATE;
            default:
                return null;
        }
    }
}
