package com.xforceplus.ultraman.app.jchsufuchifoods.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * match_status_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-05-22
 */
public enum MatchStatusEnum {

    _1("1", "未匹配"),
    _2("2", "部分匹配"),
    _3("3", "已匹配");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MatchStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchStatusEnum fromCode(String code) {
        return Stream.of(MatchStatusEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
