package com.xforceplus.ultraman.app.jchsufuchifoods.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * price_quantity_method
 * </p>
 *
 * @author ultraman
 * @since 2024-05-22
 */
public enum PriceQuantityMethod {

    _1("1", "保单价"),
    _2("2", "保单价且数量取整"),
    _3("3", "保数量"),
    _4("4", "保数量且数量取整");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PriceQuantityMethod(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PriceQuantityMethod fromCode(String code) {
        return Stream.of(PriceQuantityMethod.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
