package com.xforceplus.ultraman.app.jchsufuchifoods.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * process_status
 * </p>
 *
 * @author ultraman
 * @since 2024-05-22
 */
public enum ProcessStatus {

    WAIT("wait", "待上传"),
    PROCESSING("processing", "处理中"),
    FAIL("fail", "上传失败"),
    SUCCESS("success", "上传成功"),
    ABANDON("abandon", "已作废");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProcessStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProcessStatus fromCode(String code) {
        return Stream.of(ProcessStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
