package com.xforceplus.ultraman.app.jchsufuchifoods.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * rule_config_type
 * </p>
 *
 * @author ultraman
 * @since 2024-05-22
 */
public enum RuleConfigType {

    PRICE_QUANTITY_RULE("priceQuantityRule", "价格数量规则配置"),
    LIGHT_SEASON("lightSeason", "淡旺季限额配置"),
    DISCOUNT_RATE("discountRate", "折扣率预警报错配置");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RuleConfigType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RuleConfigType fromCode(String code) {
        return Stream.of(RuleConfigType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
