package com.xforceplus.ultraman.app.jchsufuchifoods.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * system_orig_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-05-22
 */
public enum SystemOrigEnum {

    RED_LETTER("redLetter", "红字信息表"),
    PRE_INVOICE("preInvoice", "预制发票"),
    EXCEL("excel", "导入");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SystemOrigEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SystemOrigEnum fromCode(String code) {
        return Stream.of(SystemOrigEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
