package com.xforceplus.ultraman.app.jchsufuchifoods.metadata.validator;

import com.xforceplus.ultraman.app.jchsufuchifoods.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.jchsufuchifoods.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-05-22
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(PriceQuantityMethod.class)) {
            isValid = null != PriceQuantityMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PriceQuantityMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(RuleConfigType.class)) {
            isValid = null != RuleConfigType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RuleConfigType.class.getSimpleName());
            }
        }
        if(clazz.equals(SystemOrigEnum.class)) {
            isValid = null != SystemOrigEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SystemOrigEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceTypeEnum.class)) {
            isValid = null != InvoiceTypeEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatusEnum.class)) {
            isValid = null != MatchStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ProcessStatus.class)) {
            isValid = null != ProcessStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProcessStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
