package com.xforceplus.ultraman.app.jchsufuchifoods.metadata.validator;

import com.xforceplus.ultraman.app.jchsufuchifoods.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.jchsufuchifoods.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-05-22
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(PriceQuantityMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PriceQuantityMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PriceQuantityMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(RuleConfigType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RuleConfigType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RuleConfigType.class.getSimpleName());
            }
        }
        if(clazz.equals(SystemOrigEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SystemOrigEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SystemOrigEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceTypeEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceTypeEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ProcessStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProcessStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProcessStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
