/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.app.jchsufuchifoods.metadata.validator;

import com.xforceplus.ultraman.app.jchsufuchifoods.metadata.validator.annotation.CheckUltramanEmail;
import java.util.Arrays;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class UltramanEmailConstraintValidator
implements ConstraintValidator<CheckUltramanEmail, String> {
    private final String MSG_FORMAT = "value suffix must one of %s";
    private final String TYPE_NO_LIMIT = "1";
    private final String TYPE_LIMIT = "2";
    String type;
    String emailSuffixes;

    public void initialize(CheckUltramanEmail constraintAnnotation) {
        this.type = constraintAnnotation.type();
        this.emailSuffixes = constraintAnnotation.emailSuffixes();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        boolean isValid;
        if (null == value || value.length() == 0) {
            return true;
        }
        if (!"2".equals(this.type)) {
            return true;
        }
        if (null == this.emailSuffixes || this.emailSuffixes.length() == 0) {
            return true;
        }
        boolean bl = isValid = Arrays.asList(this.emailSuffixes.split(",")).stream().filter(suffix -> value.endsWith((String)suffix)).count() > 0L;
        if (!isValid) {
            this.unValidMsg(context, this.emailSuffixes);
        }
        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(String.format("value suffix must one of %s", enumName)).addConstraintViolation();
    }
}

