package com.xforceplus.ultraman.app.jchuazhu.controller;


/**
 * feign客户端
 *
 * @author ultraman
 * @date 2022-11-22
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jchuazhu.entity.MasterDataInterface;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-huazhu")
public interface MasterDataInterfaceFeignApi {

  /**
   * 通过id查询
   * @param  id
   * @return R
   */
  @GetMapping("/masterDataInterface/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增
   * @param masterDataInterface 
   * @return R
   */
  @PostMapping("/masterDataInterface/add")
  public R save(@RequestBody MasterDataInterface masterDataInterface);

  /**
   * 修改
   * @param masterDataInterface 
   * @return R
   */
  @PostMapping("/masterDataInterface/update")
  public R updateById(@RequestBody MasterDataInterface masterDataInterface);

  /**
   * 通过id删除
   * @param  id
   * @return R
   */
  @DeleteMapping("/masterDataInterface/del/{id}" )
  public R removeById(@PathVariable Long id);

}