package com.xforceplus.ultraman.app.jchuazhu.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2023-06-06
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jchuazhu.entity.MerchantBankinfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-huazhu")
public interface MerchantBankinfoFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/merchantBankinfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param merchantBankinfo ${table.comment}
   * @return R
   */
  @PostMapping("/merchantBankinfo/add")
  public R save(@RequestBody MerchantBankinfo merchantBankinfo);

  /**
   * 修改${table.comment}
   * @param merchantBankinfo ${table.comment}
   * @return R
   */
  @PostMapping("/merchantBankinfo/update")
  public R updateById(@RequestBody MerchantBankinfo merchantBankinfo);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/merchantBankinfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}