package com.xforceplus.ultraman.app.jchuazhu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据处理状态
 * </p>
 *
 * @author ultraman
 * @since 2023-05-19
 */
public enum ProcessStatus {

    S1("S1", "接收数据成功"),
    F1("F1", "接收数据失败"),
    S2("S2", "业务处理成功"),
    F2("F2", "业务处理失败"),
    F99("F99", "单据作废"),
    S99("S99", "单据中心处理完成");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ProcessStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProcessStatus fromCode(String code){
        switch(code) {
            case "S1":
                return S1;
            case "F1":
                return F1;
            case "S2":
                return S2;
            case "F2":
                return F2;
            case "F99":
                return F99;
            case "S99":
                return S99;
            default:
                return null;
        }
    }
}
