package com.xforceplus.ultraman.app.jchuazhu.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 快照格式
 * </p>
 *
 * @author ultraman
 * @since 2022-11-22
 */
public enum SnapshotFormat {

    DIRECT("direct", "直接存取"),
    FILE("file", "文件存取");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SnapshotFormat(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SnapshotFormat fromCode(String code){
        switch(code) {
            case "direct":
                return DIRECT;
            case "file":
                return FILE;
            default:
                return null;
        }
    }
}
