package com.xforceplus.ultraman.app.jchuazhu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 处理状态
 * </p>
 *
 * @author ultraman
 * @since 2023-05-18
 */
public enum OfflineInvoiceStatus {

    _0("0", "处理中"),
    _1("1", "处理成功"),
    _2("2", "处理失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OfflineInvoiceStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OfflineInvoiceStatus fromCode(String code) {
        return Stream.of(OfflineInvoiceStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
