package com.xforceplus.ultraman.app.jchuazhu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 验真状态
 * </p>
 *
 * @author ultraman
 * @since 2023-05-18
 */
public enum VeriStatus {

    _1("1", "待查验"),
    _2("2", "查验中"),
    _3("3", "查验成功"),
    _4("4", "查验失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    VeriStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VeriStatus fromCode(String code) {
        return Stream.of(VeriStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
