package com.xforceplus.ultraman.app.jchuazhu.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * offline_invoice
 * </p>
 *
 * @author ultraman
 * @since 2023-05-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OfflineInvoice implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 业务单号
   */
  private String receiptNo;
  /**
   * 单据金额
   */
  private BigDecimal receiptAmount;
  /**
   * 发票使用金额
   */
  private BigDecimal invoiceAmount;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 购方名称
   */
  private String purchaserName;
  /**
   * 购方税号
   */
  private String purchaserTaxNo;
  /**
   * 销方税号
   */
  private String sellerTaxNo;
  /**
   * 发票代码
   */
  private String invoiceCode;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 处理状态
   */
  private String offlineInvoiceStatus;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 批次号
   */
  private String batchNo;
  /**
   * 购方编号
   */
  private String purchaserNo;
  /**
   * 备注
   */
  private String remark;
  /**
   * 影像ID
   */
  private String imageId;
  /**
   * 业务单据类型
   */
  private String receiptType;
  /**
   * 集团业务类型
   */
  private String groupBusinessType;
  /**
   * NC编码
   */
  private String ncCode;
  /**
   * 税期
   */
  private String taxPeriod;
  /**
   * 错误信息
   */
  private String errorMessage;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("receiptNo", receiptNo);
      map.put("receiptAmount", receiptAmount);
      map.put("invoiceAmount", invoiceAmount);
      map.put("sellerName", sellerName);
      map.put("purchaserName", purchaserName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("offlineInvoiceStatus", offlineInvoiceStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("batchNo", batchNo);
      map.put("purchaserNo", purchaserNo);
      map.put("remark", remark);
      map.put("imageId", imageId);
      map.put("receiptType", receiptType);
      map.put("groupBusinessType", groupBusinessType);
      map.put("ncCode", ncCode);
      map.put("taxPeriod", taxPeriod);
      map.put("errorMessage", errorMessage);

      return map;
  }

  public static OfflineInvoice fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OfflineInvoice entity = new OfflineInvoice();

    if(map.containsKey("receiptNo")) {
      Object obj = map.get("receiptNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiptNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiptAmount")) {
      Object obj = map.get("receiptAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceiptAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceiptAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceiptAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceiptAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceiptAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmount")) {
      Object obj = map.get("invoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("offlineInvoiceStatus")) {
      Object obj = map.get("offlineInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOfflineInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("imageId")) {
      Object obj = map.get("imageId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setImageId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiptType")) {
      Object obj = map.get("receiptType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiptType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("groupBusinessType")) {
      Object obj = map.get("groupBusinessType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGroupBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncCode")) {
      Object obj = map.get("ncCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNcCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPeriod")) {
      Object obj = map.get("taxPeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorMessage")) {
      Object obj = map.get("errorMessage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMessage((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("receiptNo")) {
      Object obj = map.get("receiptNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiptNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiptAmount")) {
      Object obj = map.get("receiptAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReceiptAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReceiptAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReceiptAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReceiptAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReceiptAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmount")) {
      Object obj = map.get("invoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("offlineInvoiceStatus")) {
      Object obj = map.get("offlineInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOfflineInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("imageId")) {
      Object obj = map.get("imageId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setImageId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiptType")) {
      Object obj = map.get("receiptType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiptType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("groupBusinessType")) {
      Object obj = map.get("groupBusinessType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGroupBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ncCode")) {
      Object obj = map.get("ncCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNcCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPeriod")) {
      Object obj = map.get("taxPeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorMessage")) {
      Object obj = map.get("errorMessage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setErrorMessage((String)obj);
        }
      } else{
      }
    }
  }
}
