package com.xforceplus.ultraman.app.jchuazhu.metadata.validator;

import com.xforceplus.ultraman.app.jchuazhu.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.jchuazhu.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-05-18
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuditStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SignForStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SignForStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SignForStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VeriStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VeriStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VeriStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(Code.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Code.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Code.class.getSimpleName());
            }
        }
        if(clazz.equals(SendStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SendStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SendStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxpayerScale.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxpayerScale.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxpayerScale.class.getSimpleName());
            }
        }
        if(clazz.equals(SubdomainCode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SubdomainCode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SubdomainCode.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxType.class.getSimpleName());
            }
        }
        if(clazz.equals(IsValid.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsValid.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsValid.class.getSimpleName());
            }
        }
        if(clazz.equals(MerchantProperty.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MerchantProperty.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MerchantProperty.class.getSimpleName());
            }
        }
        if(clazz.equals(ExecStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ExecStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ExecStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OfflineInvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OfflineInvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OfflineInvoiceStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
