package com.xforceplus.ultraman.app.jchuazhu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 主数据类型
 * </p>
 *
 * @author ultraman
 * @since 2023-03-20
 */
public enum Code {

    HOTEL__INVOICE_TITLE_INFO("Hotel_InvoiceTitleInfo", "酒店开票抬头信息"),
    HOTEL__BASIC_INFO("Hotel_BasicInfo", "酒店基础信息"),
    HOTEL__N_C_INFO("Hotel_NCInfo", "酒店NC信息"),
    H_R__HOTEL_MANAGEMENT_POSITION("HR_HotelManagementPosition", "管店关系"),
    H_R__EMP_HOTEL_RELATION("HR_EmpHotelRelation", "人店关系"),
    H_R__HOTEL_MANAGER_OTHER("HR_HotelManagerOther", "其他管店"),
    MERCHANT__BASICINFO("Merchant_Basicinfo", "客商基本信息"),
    MERCHANT__BANKINFO("Merchant_Bankinfo", "客商银行账号信息"),
    MERCHANT__COMPANY("Merchant_Company", "客商公司信息"),
    MERCHANT__COMPANY_RELATION("Merchant_CompanyRelation", "客商与客商公司关系");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Code(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Code fromCode(String code) {
        return Stream.of(Code.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
