package com.xforceplus.ultraman.app.jchuazhu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 客商性质
 * </p>
 *
 * @author ultraman
 * @since 2023-03-20
 */
public enum MerchantProperty {

    _1("1", "华住公司"),
    _2("2", "直营门店"),
    _3("3", "加盟门店"),
    _4("4", "外部企业"),
    _5("5", "华住员工");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MerchantProperty(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MerchantProperty fromCode(String code) {
        return Stream.of(MerchantProperty.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
