package com.xforceplus.ultraman.app.jchuazhu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 用户类型
 * </p>
 *
 * @author ultraman
 * @since 2023-03-20
 */
public enum SubdomainCode {

    S("S", "供应商"),
    EHR("EHR", "EHR员工");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SubdomainCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SubdomainCode fromCode(String code) {
        return Stream.of(SubdomainCode.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
