package com.xforceplus.ultraman.app.jchuazhu.metadata.validator;

import com.xforceplus.ultraman.app.jchuazhu.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.jchuazhu.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-03-20
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = null != AuditStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SignForStatus.class)) {
            isValid = null != SignForStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SignForStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VeriStatus.class)) {
            isValid = null != VeriStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VeriStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(Code.class)) {
            isValid = null != Code.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Code.class.getSimpleName());
            }
        }
        if(clazz.equals(SendStatus.class)) {
            isValid = null != SendStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SendStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxpayerScale.class)) {
            isValid = null != TaxpayerScale.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxpayerScale.class.getSimpleName());
            }
        }
        if(clazz.equals(SubdomainCode.class)) {
            isValid = null != SubdomainCode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SubdomainCode.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxType.class)) {
            isValid = null != TaxType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxType.class.getSimpleName());
            }
        }
        if(clazz.equals(IsValid.class)) {
            isValid = null != IsValid.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsValid.class.getSimpleName());
            }
        }
        if(clazz.equals(MerchantProperty.class)) {
            isValid = null != MerchantProperty.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MerchantProperty.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
