package com.xforceplus.ultraman.app.jchuazhu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 执行状态
 * </p>
 *
 * @author ultraman
 * @since 2023-05-04
 */
public enum ExecStatus {

    _0("0", "未执行"),
    _1("1", "执行中"),
    _2("2", "已执行");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ExecStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExecStatus fromCode(String code) {
        return Stream.of(ExecStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
