package com.xforceplus.ultraman.app.jchuazhu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是否有效
 * </p>
 *
 * @author ultraman
 * @since 2023-05-04
 */
public enum IsValid {

    _0("0", "有效"),
    _1("1", "无效");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsValid(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsValid fromCode(String code) {
        return Stream.of(IsValid.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
