package com.xforceplus.ultraman.app.jchuazhu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 税种
 * </p>
 *
 * @author ultraman
 * @since 2023-05-04
 */
public enum TaxType {

    VALUE_ADDED_TAX("valueAddedTax", "增值税"),
    CORPORATE_INCOME_TAX("corporateIncomeTax", "企业所得税"),
    STAMP_DUTY("stampDuty", "印花税"),
    OTHER_SMALL_TAXES("otherSmallTaxes", "其他小税种");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxType fromCode(String code) {
        return Stream.of(TaxType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
