package com.xforceplus.ultraman.app.jchuazhu.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 纳税人规模
 * </p>
 *
 * @author ultraman
 * @since 2023-05-04
 */
public enum TaxpayerScale {

    _1("1", "一般纳税人"),
    _2("2", "小规模纳税人");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxpayerScale(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxpayerScale fromCode(String code) {
        return Stream.of(TaxpayerScale.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
