package com.xforceplus.ultraman.app.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jchuazhu.entity.Logistics;
import com.xforceplus.ultraman.app.jchuazhu.service.ILogisticsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-02
 */
@RestController
public class LogisticsController {

  @Autowired
  private ILogisticsService logisticsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param logistics ${table.comment}
   * @return
   */
  @GetMapping("/logisticss" )
  public XfR getLogisticss(XfPage page, Logistics logistics) {
    return XfR.ok(logisticsServiceImpl.page(page, Wrappers.query(logistics)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/logisticss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(logisticsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param logistics ${table.comment}
   * @return XfR
   */
  @PostMapping("/logisticss")
  public XfR save(@RequestBody Logistics logistics) {
     return XfR.ok(logisticsServiceImpl.save(logistics));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param logistics ${table.comment}
   * @return XfR
   */
  @PutMapping("/logisticss/{id}")
  public XfR putUpdate(@RequestBody Logistics logistics,@PathVariable Long id) {
      logistics.setId(id);
      return XfR.ok(logisticsServiceImpl.updateById(logistics));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param logistics ${table.comment}
   * @return XfR
   */
  @PatchMapping("/logisticss/{id}")
  public XfR patchUpdate(@RequestBody Logistics logistics,@PathVariable Long id) {
      Logistics uplogistics = logisticsServiceImpl.getById(id);
      if(uplogistics != null){
        uplogistics = ObjectCopyUtils.copyProperties(logistics,uplogistics,true);
      }
      return XfR.ok(logisticsServiceImpl.updateById(uplogistics));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/logisticss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(logisticsServiceImpl.removeById(id));
  }

  @PostMapping("/logisticss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "logistics");
     params.put("request", condition);

     return XfR.ok(logisticsServiceImpl.querys(params));
  }

}
