package com.xforceplus.ultraman.app.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jchuazhu.entity.MerchantBankinfo;
import com.xforceplus.ultraman.app.jchuazhu.service.IMerchantBankinfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-02
 */
@RestController
public class MerchantBankinfoController {

  @Autowired
  private IMerchantBankinfoService merchantBankinfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param merchantBankinfo ${table.comment}
   * @return
   */
  @GetMapping("/merchantbankinfos" )
  public XfR getMerchantBankinfos(XfPage page, MerchantBankinfo merchantBankinfo) {
    return XfR.ok(merchantBankinfoServiceImpl.page(page, Wrappers.query(merchantBankinfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/merchantbankinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(merchantBankinfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param merchantBankinfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/merchantbankinfos")
  public XfR save(@RequestBody MerchantBankinfo merchantBankinfo) {
     return XfR.ok(merchantBankinfoServiceImpl.save(merchantBankinfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param merchantBankinfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/merchantbankinfos/{id}")
  public XfR putUpdate(@RequestBody MerchantBankinfo merchantBankinfo,@PathVariable Long id) {
      merchantBankinfo.setId(id);
      return XfR.ok(merchantBankinfoServiceImpl.updateById(merchantBankinfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param merchantBankinfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/merchantbankinfos/{id}")
  public XfR patchUpdate(@RequestBody MerchantBankinfo merchantBankinfo,@PathVariable Long id) {
      MerchantBankinfo upmerchantBankinfo = merchantBankinfoServiceImpl.getById(id);
      if(upmerchantBankinfo != null){
        upmerchantBankinfo = ObjectCopyUtils.copyProperties(merchantBankinfo,upmerchantBankinfo,true);
      }
      return XfR.ok(merchantBankinfoServiceImpl.updateById(upmerchantBankinfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/merchantbankinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(merchantBankinfoServiceImpl.removeById(id));
  }

  @PostMapping("/merchantbankinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "merchant_bankinfo");
     params.put("request", condition);

     return XfR.ok(merchantBankinfoServiceImpl.querys(params));
  }

}
